/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.lighting;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.google.inject.Inject;
import technology.rocketjump.undermount.rendering.custom_libgdx.ShaderLoader;

public class CombinedLightingResultRenderer {
    private static final int NUM_TRIANGLES = 2;
    private static final int VERTEX_SIZE = 2;
    private static final int NUM_INDEX_PER_TRIANGLE = 3;
    private final ShaderProgram combinedShader;
    private Mesh fullScrenMesh;

    @Inject
    public CombinedLightingResultRenderer() {
        int MAX_VERTICES = 12;
        float[] vertices = new float[12];
        int MAX_INDICES = 6;
        short[] indices = new short[MAX_INDICES];
        this.fullScrenMesh = new Mesh(Mesh.VertexDataType.VertexArray, true, 12, MAX_INDICES, new VertexAttribute(1, 2, "a_position"));
        int vertexIndex = 0;
        vertices[vertexIndex++] = -1.0f;
        vertices[vertexIndex++] = -1.0f;
        vertices[vertexIndex++] = -1.0f;
        vertices[vertexIndex++] = 1.0f;
        vertices[vertexIndex++] = 1.0f;
        vertices[vertexIndex++] = 1.0f;
        vertices[vertexIndex++] = 1.0f;
        vertices[vertexIndex++] = -1.0f;
        this.fullScrenMesh.setVertices(vertices);
        indices[0] = 0;
        indices[1] = 1;
        indices[2] = 2;
        indices[3] = 2;
        indices[4] = 3;
        indices[5] = 0;
        this.fullScrenMesh.setIndices(indices);
        FileHandle vertexShaderFile = Gdx.files.classpath("shaders/combined_lighting_vertex_shader.glsl");
        FileHandle fragmentShaderFile = Gdx.files.classpath("shaders/combined_lighting_fragment_shader.glsl");
        this.combinedShader = ShaderLoader.createShader(vertexShaderFile, fragmentShaderFile);
    }

    public void renderFinal(TextureRegion diffuseTextureRegion, TextureRegion lightingTextureRegion) {
        Gdx.gl.glDisable(3042);
        this.combinedShader.begin();
        this.combinedShader.setUniformi("u_textureLighting", 1);
        lightingTextureRegion.getTexture().bind(1);
        this.combinedShader.setUniformi("u_textureDiffuse", 0);
        diffuseTextureRegion.getTexture().bind(0);
        this.fullScrenMesh.render(this.combinedShader, 4);
        this.combinedShader.end();
    }
}

